"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
/* eslint-disable @kbn/eslint/require-license-header */

/**
 *    Copyright 2019 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

function _default(kibanaCore) {
  kibanaCore.http.registerOnPreAuth(async function (request, response, toolkit) {
    request = (0, _coreHttpRouterServerInternal.ensureRawRequest)(request);
    request.headers['x-forwarded-for'] = (request.headers['x-forwarded-for'] ? request.headers['x-forwarded-for'] + ',' : '') + request.info.remoteAddress;
    request.headers['x-forwarded-port'] = request.headers['x-forwarded-port'] || request.info.remotePort;
    request.headers['x-forwarded-proto'] = request.headers['x-forwarded-proto'] || request.server.info.protocol;
    request.headers['x-forwarded-host'] = request.headers['x-forwarded-host'] || request.info.host;
    return toolkit.next();
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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